#!/usr/bin/python
# -*- coding: ISO-8859-15 -*-
import traceback
import sys
import shutil
import zipfile
import os
import logging
import magic

import _common
import common
import db_common
import qry
import fs
import libjobdext

script_name = os.path.basename(__file__)
logger = logging.getLogger(script_name)

def execscript(params = None, edb = None) :
	"""
	La fonction execscript est la fonction principale (comme une fonction main en C par exemple)
	qui sera appele par le serveur des travaux afin d'excuter le script.

	@param params: la liste des arguments fournis au script.
	@type params: list

	@param edb: Une instance de connexion  la base de donnes.
	@type edb: instance
	"""
	parameters = {}

	if params is None :
		# Dans le cas d'un appel en ligne de commande on rcupre les arguments qui ont t fournies via cette ligne de commande.
		params = sys.argv

	# Ci-dessous on rcupre dans un dictionnaire python les arguments passs au script.
	ret = _common.getscriptparameters(parameters, params, "instance", "jobqueueid", "secusrid","jobtplid","changetostep","filteronstep")

	if ret <> 0 :
		return ret, str(ret)

	# On	initialisation le contexte et surtout la session ezged.
	gctx = common.common(parameters["instance"])
	gses = common.session(parameters["secusrid"], gctx.context[gctx.context["applic"] + ".default_language"], gctx,
						  parameters["jobqueueid"])

	# On initialise la connexion  la base de donnes via la session ezged.
	if edb == None :
		db_common.sql_dbcontext(gses)
		db = gses.db
	else :
		gses.db = edb
		db = edb

	if db == None :
		return -1, gses.lng("Unable to connect to database")

	else :
		jobd_dir = _common.dopath(gses.common.context["dirs.spooldir"], "jobd")
		jobdir = _common.dopath(jobd_dir, parameters["jobqueueid"])
		_common.makealldir(jobdir)

		jobtplid = parameters["jobtplid"]
		stepsrc = parameters["filteronstep"]
		stepdst = parameters["changetostep"]

		# Dans ce bloc on va crire toute la logique de notre script.
		myquery = qry.qry(gses)
		# myquery.table=[["@ljoin","_fsfile.FSFILE_ID","_docpak.DOCPAK_FSFILEID"]]
		myquery.table = ["_jobqueue"]
		myquery.field=[["_jobqueue","JOBQUEUE_ID"]]

		c1 = [["@fld", "_jobqueue", "JOBQUEUE_JOBTPLID"], ["@op", "="], ["@val", jobtplid]]

		c2a = [["@fld", "_jobqueue", "JOBQUEUE_STATUS"], ["@op", "="], ["@val", 4]]
		c2b = [["@fld", "_jobqueue", "JOBQUEUE_STATUS"], ["@op", "="], ["@val", 5]]

		c2 = [c2a, ["@op","OR"], c2b]

		c3 = [["@fld", "_jobqueue", "JOBQUEUE_STEP"], ["@op", "="], ["@val", stepsrc]]

		myquery.cond = [c1, ["@op", "AND"],c2]

		if stepsrc != "":
			myquery.cond = [myquery.cond, ["@op","AND"], c3 ]

		myquery.order = [["@fld", "_jobqueue", "JOBQUEUE_ID", "A"]]
		sql_query = myquery.sql()

		logger.info("Looking for jobs in error where jobtplid = %s and step = %s" % (jobtplid, stepsrc))

		result = gses.db.query(sql_query)
		if result is not None:
			while 1:
				vrow = gses.db.fetchrow(result)
				if vrow is None:
					break

				jobqueue_id = vrow["JOBQUEUE_ID"]
				jobqueue_dir = os.path.join(jobd_dir, str(jobqueue_id))

				if not os.path.exists(jobqueue_dir):
					logger.info("\tJobqueue directory does not exists. Continue.")
					continue

				logger.info("\n\tChecking job #%d" % jobqueue_id)

				zip_path = os.path.join(jobqueue_dir, "Facture_Pivot.xml")
				metadata_path = os.path.join(jobqueue_dir, "metadata.txt")
				flag_file = os.path.join(jobqueue_dir, "chorux_fix_done")

				if os.path.exists(flag_file):
					logger.info("\tAllready done. Continue.")
					continue

				if not os.path.exists(zip_path):
					logger.info("\tFile Facture_Pivot.xml not found. Continue.")
					continue

				if not os.path.exists(metadata_path):
					logger.info("\tFile metadata.txt not found. Continue.")
					continue

				fp = open(zip_path, "rb")
				zip_content = fp.read()
				fp.close()
				
				if not magic.guessMime(zip_content) == "application/zip" :
					logger.info("\tFile Facture_Pivot.xml is not a zip file. Continue")
					continue
				else :
					logger.info("\tFile Facture_Pivot.xml is a zip file. Process it.")

				# Create extraction directory for the zip
				zip_extraction_dir = _common.dopath(jobqueue_dir, "pivot_unzip")
				_common.makealldir(zip_extraction_dir)

				# Read the zip and list its content
				chorus_zip = zipfile.ZipFile(zip_path)
				archives_list = chorus_zip.filelist

				if len(archives_list) == 0 :
					logger.info("\tZip is empty. Continue.")
					continue

				pivot_xml_found = False
				for archive in archives_list:
					archive_filename = archive.filename

					if archive_filename == "PivotS.xml":
						pivot_xml_found = True
						archive_content = chorus_zip.read(archive_filename)

						logger.info("\tAppend PivotS.xml content to metadata.txt")
						fp = open(metadata_path, "a")
						fp.write("\n")
						fp.write(archive_content)
						fp.close()

				if not pivot_xml_found:
					logger.info("PivotS.xml not found in zip. Continue")
					continue

				logger.info("\tUpdate job #%d to step %s and activate it." % (jobqueue_id, stepdst) )
				db_common.dbgenericupdate(
					usession = gses,
					itbl = "_jobqueue",
					iflds = ["JOBQUEUE_STEP", "JOBQUEUE_ACTIVE", "JOBQUEUE_STATUS"],
					ivalues = [stepdst, 1, 0],
					iidval = jobqueue_id
				)

				logger.info("\tFlag job #%d as done." % (jobqueue_id))
				fp = open(flag_file, "w")
				fp.write("1")
				fp.close()

			gses.db.delcursor(result)

	if edb is None :
		# Le script a t appel sans lui fournir une connexion  la bdd.
		# Dans ce cas on ferme la connexion que nous avons ouverte au sein du script.
		db.disconnect()

	return 0, "ok"


if __name__ == "__main__" :
	logger.addHandler(logging.StreamHandler())
	logger.setLevel(logging.DEBUG)

	try:
		sys.argv[6]
	except:
		sys.argv.append("")

	try :
		errorcode, errorstr = execscript()
	except :
		print "@error"
		traceback.print_exc(file = sys.stdout)
		sys.exit(-100)

	if errorcode <> 0 :
		print "@error", errorstr
	sys.exit(errorcode)

